package w83a.w83aUtilidades;

import java.io.ByteArrayOutputStream;
import java.util.Date;

import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFooter;
import org.apache.poi.hssf.usermodel.HSSFHeader;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;

import w83a.w83aBeans.W83aUsuarioXLNetsBean;
import w83a.w83aOperacionesPaso.w83aResultados.W83aClsEstilosExcel;
import w83a.w83aUtilidadesComunes.W83aClsTrazas;
import w83a.w83aUtilidadesComunes.W83aDateUtil;

/**
 * 
 * @author 
 *
 */
public class W83aUtilidadesExcel{
	
	public HSSFCellStyle styleTextoParCentrado;
	public HSSFCellStyle styleTextoImparCentrado;
	public HSSFCellStyle sytleNegritaFormateado;
	public HSSFCellStyle styleTextoPar;
	public HSSFCellStyle styleTextoImpar;
	public HSSFCellStyle styleTextoParNumero;
	public HSSFCellStyle styleTextoImparNumero;
	public HSSFCellStyle styleBordeDcha;
	public HSSFCellStyle styleBordeIzda;
	public HSSFCellStyle stylePorcentajesDcha;
	public HSSFCellStyle styleBordeArriba;
	public HSSFCellStyle styleCentrado;
	public HSSFCellStyle styleCentradoNumeroFormateado;
	public HSSFCellStyle styleDerechaNumeroFormateado;
	public HSSFCellStyle styleBordeAbajo;
	public HSSFCellStyle styleBordeArribaFormateado;
	public HSSFCellStyle styleCentradoSubrayado;
	
	public W83aUtilidadesExcel(HSSFWorkbook wb) {
		
		super();
		this.definirEstilos(wb);//NOPMD
		
	}
	
	/**
	 * definirEstilos.
	 * @param wb HSSFWorkbook 
	 */
	public void  definirEstilos (HSSFWorkbook wb){
		 
		//creating a custom palette for the workbook
		HSSFPalette palette = wb.getCustomPalette();
		palette.setColorAtIndex((short)22, (byte) 216, (byte) 216, (byte) 216); 
		palette.setColorAtIndex((short)55, (byte) 191, (byte) 191, (byte) 191); 		
		
		this.styleTextoPar = W83aClsEstilosExcel.estiloParCadena(wb);
		this.styleTextoImpar = W83aClsEstilosExcel.estiloInparCadena(wb);
		this.styleTextoImparCentrado = W83aClsEstilosExcel.styleTextoImparCentrado(wb);
		this.styleTextoParCentrado = W83aClsEstilosExcel.styleTextoParCentrado(wb);
		this.sytleNegritaFormateado = W83aClsEstilosExcel.sytleNegritaFormateado(wb);
		this.styleTextoParNumero = W83aClsEstilosExcel.estiloParNumero(wb);
		this.styleTextoImparNumero = W83aClsEstilosExcel.estiloInparNumero(wb);
		this.styleTextoImparNumero = W83aClsEstilosExcel.estiloInparNumero(wb);
		this.styleBordeDcha = W83aClsEstilosExcel.styleBordeDcha(wb);
		this.styleBordeIzda = W83aClsEstilosExcel.styleBordeIzda(wb);
		this.stylePorcentajesDcha = W83aClsEstilosExcel.stylePorcentajesDcha(wb);
		this.styleBordeArriba = W83aClsEstilosExcel.styleBordeArriba(wb);
		this.styleCentrado = W83aClsEstilosExcel.styleCentrado(wb);
		this.styleCentradoNumeroFormateado = W83aClsEstilosExcel.styleCentradoNumeroFormateado(wb);
		this.styleDerechaNumeroFormateado = W83aClsEstilosExcel.styleDerechaNumeroFormateado(wb);
		this.styleBordeAbajo = W83aClsEstilosExcel.styleBordeAbajo(wb);
		this.styleBordeArribaFormateado = W83aClsEstilosExcel.styleBordeArribaFormateado(wb);
		this.styleCentradoSubrayado = W83aClsEstilosExcel.styleCentradoSubrayado(wb);
	}

	public static byte[] fncExcelToBytes(HSSFWorkbook hsPfLibro) throws Exception
	{
		  ByteArrayOutputStream outPutStream = new ByteArrayOutputStream();
		  hsPfLibro.write(outPutStream);
		  byte[] bytes = outPutStream.toByteArray();
		  outPutStream.close();
		        
		  return bytes;
		
	}
	public static void crearCabeceraPieEstandar(HSSFSheet sheet, String idioma,W83aUsuarioXLNetsBean usuario ) throws Exception{
		  HSSFHeader.fontSize((short)8);
	      HSSFHeader header = sheet.getHeader();
	      header.setLeft(HSSFHeader.fontSize((short) 8)+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.eleccionesSindicales",idioma));
	      header.setRight(HSSFHeader.fontSize((short) 8)+" "+W83aDateUtil.getInstance().getLocaleStringFromDate(new Date(), idioma));
	      
	      HSSFFooter footer = sheet.getFooter();
	      W83aClsTrazas.trazaError(null,"usuario - "+usuario,null);
	      W83aClsTrazas.trazaError(null,"usuario.getCalleListadosFormateada() - "+usuario.getCalleListadosFormateada(),null);
	      footer.setCenter(HSSFFooter.fontSize((short) 8)+usuario.getCalleListadosFormateada());
	      footer.setRight(HSSFFooter.fontSize((short) 8)+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.label.pag",idioma,new String[]{footer.page()}));
	}
   

}
